
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

    public class GameObject
    {
      protected double x,y;
      protected double width, height;
      private String[] bitmaps;
      protected int displayedFrame;
      private int animationSpeed;
      private int MAX_ANIMATION_SPEED = 10;
      private int START_TIME = 11;
	  private int count;
      protected CircuitConductor cc;
      private MediaManager mediaManager;
      private boolean killable;

      public GameObject(CircuitConductor cc) {
        this.cc = cc;
        mediaManager = cc.getMediaManager();
        displayedFrame = 0;
        animationSpeed = 1;
        count = 0;
      }

      public void remove()
      {
		  killable = true;
	  }

	  public boolean toBeKilled()
	  {
		  return killable;
	  }


      public void paint(Graphics2D g)
      {
        g.drawImage(mediaManager.getBitmap(bitmaps[displayedFrame]), (int)x,(int)y, cc);
      }

      public void setAnimationSpeed(int inAnimationSpeed)
      {
		  if(inAnimationSpeed > 10)
		     animationSpeed = MAX_ANIMATION_SPEED;
		  else if (animationSpeed < 1)
		     animationSpeed = 1;
		  else
		     animationSpeed = inAnimationSpeed; }

      public void setSpriteNames(String[] inNames)
      {
        bitmaps = inNames;
        height = 0;
        width = 0;
        for (int i = 0; i < inNames.length; i++ )
        {
			BufferedImage image = mediaManager.getBitmap(bitmaps[i]);
			height = Math.max(height,image.getHeight());
			width = Math.max(width,image.getWidth());
		}
      }

      public void collision(GameObject inGameObject){

	  }

      public void move()
      {
		  int elapsedTime = --count - animationSpeed;
		  if(elapsedTime <= 0)
		  {
			  if(displayedFrame >= bitmaps.length - 1)
			     displayedFrame = 0;
			  else
			     displayedFrame++;
			  count = START_TIME;
		  }
	  }

      public double getX()
      {
		  return x;
	  }

      public void setX(double inX)
      {
		  x = inX;
	  }

      public double getY()
      {
		  return y;
	  }

      public void setY(double inY)
      {
		  y = inY;
	  }

      public int getAnimationSpeed()
      {
		  return animationSpeed;
	  }

      public double getHeight()
      {
		  return height;
	  }

      public double getWidth()
      {
		  return width;
	  }

      public void setHeight(double inHeight)
      {
		  height = inHeight;
	  }

      public void setWidth(double inWidth)
      {
		  width = inWidth;
	  }
}
